-- 	RegisterMod Script
--
-- 	Author: 	Silas770
-- 	Date:		28.12.2018
--	Version:	1.0.0.0 (FS19)
--

print("  Registering GreenMowing Mod");

local specializations = {};
specializations["GreenMowingMower"] = {
	className = "GreenMowingMower",
	filename = g_currentModDirectory.."scr/greenMowing/GreenMowingMower.lua",
	requiredSpecs = { Mower },
	checkSpecs = {"greenMowingMower", "GreenMowingMower"}
};

RegisterMod = {};

function RegisterMod.insertSpecialization(vehicleType, name, requiredSpecs, checkSpecs)
	local allowInsertion = true;
	for _, spec in pairs(requiredSpecs) do
		allowInsertion = SpecializationUtil.hasSpecialization(spec, vehicleType.specializations);
		if not allowInsertion then
			break;
		end;
	end;
	
	if allowInsertion then
		if vehicleType.name:find('.') then
			customEnvironment = StringUtil.splitString('.', vehicleType.name)[1];
		end;
		
		if customEnvironment then
			for _, spec in pairs(checkSpecs) do
				if rawget(g_specializationManager.specializations, customEnvironment ..".".. spec) ~= nil then
					allowInsertion = false;
					break;
				end;
			end;
		end;
		
		if allowInsertion then
			local spec = g_specializationManager:getSpecializationByName(name);
			g_vehicleTypeManager:addSpecialization(vehicleType.name, spec.name);
		end;
	end;
end;

function RegisterMod.registerSpecializations()
	-- Register specializations
	for name, spec in pairs(specializations) do
		g_specializationManager:addSpecialization(name, spec.className, spec.filename, "");
	end;
	
	-- Insert specializations into vehicleTypes
	for _, vehicleType in pairs(g_vehicleTypeManager.vehicleTypes) do
		if vehicleType ~= nil then
			
			for name, spec in pairs(specializations) do
				RegisterMod.insertSpecialization(vehicleType, name, spec.requiredSpecs, spec.checkSpecs);
			end;
			
		end;
	end;
end;

RegisterMod.registerSpecializations();