heapPreview = {};
heapPreview.modDir = g_currentModDirectory;

heapPreview.metadata = {
	interface = " FS19 1.x",
	title = " HeapPreview",
	notes = " Zeigt Aktuelle Fruchtart von Haufen an",
	author = " (by HappyLooser & F/A)",
	version = " v0.1 Beta",	
	datum = " 24.11.2016",
	update = " 15.11.2020",
	web = " https://www.facebook.com/FarmingAgency",
	info = " Link Freigabe,Änderungen,Kopien oder Code Benutzung ist ohne meine Zustimmung nicht erlaubt",
	"##Orginal Link Freigabe: https://cdn.discordapp.com/attachments/303921938835701760/776909431987896340/unknown.png"
};

heapPreview.values = {	
	height = 5,
	radius = 0.5,	
	onSaveForMoh = false,
	distance = 20,
	onFoot = true,
	onVehicle = false, 
	onField = true,
	foundHeap = false,
	fillTypeName = "",
	fillType = 0,
	fillLevel = 0,	
	hx = 0,
	hy = 0;
	hz = 0,
	px = 0,
	py = 0,
	pz = 0,
	widthX = 0,
	widthZ = 0,
	heightX = 0,
	heightZ = 0,
	foundMoh = false,
	onStartCheck = true,
	heapDebug = 0,
	heapDebugTxt = {" Off", " Radius", " SavePos", " DistanceOnSave", " All"},
};


function heapPreview:loadMap(name)		
	print("---loading".. tostring(heapPreview.metadata.title).. tostring(heapPreview.metadata.version).. tostring(heapPreview.metadata.author).. "---")
end;

function heapPreview:update(dt)	
	if heapPreview:getFullSize() or heapPreview:getIngameMap() or heapPreview:getServer() then return;end;
	heapPreview:searchHeaps();

	if heapPreview.values.foundHeap then
		g_currentMission:addExtraPrintText(g_i18n:getText("statistic_fillType").. ": ".. tostring(heapPreview.values.fillTypeName));		
	end;		
end;

addModEventListener(heapPreview);

function heapPreview:setGetValues(delete, fillType, fillTypeName, fillLevel, x, y, z, widthX, widthZ, heightX, heightZ, pX, pY, pZ)
	if delete then
		heapPreview.values.foundHeap = false;
		heapPreview.values.fillType = 0;
		heapPreview.values.fillLevel = 0;
		heapPreview.values.fillTypeName = "";
		heapPreview.values.hx = 0;
		heapPreview.values.hy = 0;
		heapPreview.values.hz = 0;
		heapPreview.values.px = 0;
		heapPreview.values.py = 0;
		heapPreview.values.pz = 0;
		heapPreview.values.widthX = 0;
		heapPreview.values.widthZ = 0;
		heapPreview.values.heightX = 0;
		heapPreview.values.heightZ = 0;
	else
		heapPreview.values.fillType = fillType;
		heapPreview.values.fillTypeName = fillTypeName;
		heapPreview.values.fillLevel = fillLevel;
		heapPreview.values.hx = x;
		heapPreview.values.hy = y;
		heapPreview.values.hz = z;
		heapPreview.values.px = pX;
		heapPreview.values.py = pY;
		heapPreview.values.pz = pZ;
		heapPreview.values.widthX = widthX;
		heapPreview.values.widthZ = widthZ;
		heapPreview.values.heightX = heightX;
		heapPreview.values.heightZ = heightZ;
		heapPreview.values.foundHeap = true;		
	end;
end;

function heapPreview:getFillTypeName(fillType)
	local name = "Unknown";
	local desc = g_fillTypeManager:getFillTypeByIndex(fillType);
	if desc ~= nil then 
		name = desc.title;
	end;
	return name;
end;

function heapPreview:getFullSize()
	if g_currentMission.paused or 
		g_currentMission.manualPaused or 
		g_currentMission.physicsPaused then 
			if g_currentMission.missionDynamicInfo.isMultiplayer and g_currentMission.manualPaused then
				return false;
			end;
			return true;
		end;
	return false;
end;

function heapPreview:getIngameMap()
	return false;
end;

function heapPreview:getServer()
	if (g_server ~= nil and g_client ~= nil) or (g_client ~= nil and g_server == nil) then return false;end;	
	return true;
end;

function heapPreview:getIsOnField(x,y,z)    
    local densityBits = getDensityAtWorldPos(g_currentMission.terrainDetailId, x, y, z);
    return densityBits ~= 0;
end;

function heapPreview:searchHeaps()
	local x, y, z, rootNode = heapPreview:isHeapDraw();		
	if x ~= nil and y ~= nil and z ~= nil and rootNode ~= nil then		
		local radius = heapPreview.values.radius;		
		local x0,y0,z0 = localToWorld(rootNode, x + radius, y, z - radius);
        local x1,y1,z1 = localToWorld(rootNode, x - radius, y, z - radius);
        local x2,y2,z2 = localToWorld(rootNode, x + radius, y, z + radius);
		local x3,y3,z3 = localToWorld(rootNode, x - radius, y, z + radius); 
		local hx, hz, widthX, widthZ, heightX, heightZ = MathUtil.getXZWidthAndHeight(x0,z0, x1,z1, x2,z2);
		local xS1, zS1, widthX1, widthZ1, heightX1, heightZ1 = MathUtil.getXZWidthAndHeight(x2,z2, x1,z1, x0,z0); 
		local height = heapPreview.values.height; 

		local fillType = DensityMapHeightUtil.getFillTypeAtLine(x, y, z, x, y, z, radius);
		local fillLevel = nil;		
		if fillType ~= nil and fillType ~= 0 then
			local descName = g_fillTypeManager:getFillTypeByIndex(fillType);
			if descName.name ~= "TARP" then 
				fillLevel = DensityMapHeightUtil.getFillLevelAtArea(fillType, hx, hz, widthX, widthZ, heightX, heightZ);	
			end
		end;
		if fillLevel ~= nil and fillLevel ~= 0 then			
			heapPreview:setGetValues(false, fillType, heapPreview:getFillTypeName(fillType), fillLevel, hx, y, hz, widthX, widthZ, heightX, heightZ, x, y, z);			
		else
			heapPreview:setGetValues(true);
		end;
	else
		heapPreview:setGetValues(true);
	end;
end;

function heapPreview:isHeapDraw()	
	local x, y, z;
	local rootNode;
	local onVehicle = false;
	
	if not onVehicle and g_currentMission.player ~= nil and g_currentMission.player.rootNode ~= nil then -- Modelleicher fix, check if player exists and has rootNode
		x, y, z = getWorldTranslation(g_currentMission.player.rootNode);
		rootNode = g_currentMission.player.rootNode;
	end;
	if not heapPreview.values.onField and getIsOnField(x,y,z) then 
		return nil, nil, nil, nil;
	end;
	if not onVehicle and heapPreview.values.onFoot then return 
		x, y, z, rootNode;
	end;
	return nil, nil, nil, nil;
end;

